DROP PROCEDURE [hips].[ContactUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 22 October 2012
-- Description:   Updates an existing record in the Contacts Table
-- =============================================
CREATE PROCEDURE [hips].[ContactUpdate] 
(      @ContactId INT
      ,@Detail VARCHAR(256)
      ,@ContactMethodId INT
	  ,@UserModified VARCHAR(256)
	  ,@DateModified datetime
)
AS
BEGIN
    SET NOCOUNT ON
 DECLARE @intErrorCode int

    SET @intErrorCode = 0

    IF NOT EXISTS (SELECT TOP 1 [DateModified]
            	FROM [hips].[Contact]
				WHERE [ContactId] = @ContactId AND [DateModified] = @DateModified)
    BEGIN
        RAISERROR 50001 'Record has already been updated!'
        SET @intErrorCode = @@ERROR
    END
 IF @intErrorCode = 0
    BEGIN
        UPDATE [hips].[Contact]
           SET [Detail] = @Detail
			  ,[ContactMethodId] = @ContactMethodId
             , [DateModified] = GetDate()
             , [UserModified] = @UserModified
         WHERE [ContactID] = @ContactID

        SELECT @intErrorCode = @@ERROR
    END

    IF @intErrorCode = 0
    BEGIN
		SELECT  c.ContactId,
				c.Detail,
				c.ContactMethodId,
				cm.TelecommunicationType,
				cm.Description,
				cm.CdaType,
				c.DateCreated,
				c.UserCreated,
				c.DateModified,
				c.UserModified
				
		FROM  hips.Contact c
		INNER JOIN hips.ContactMethod AS cm ON cm.ContactMethodId = c.ContactMethodId
		WHERE c.ContactId = @ContactId
    END

    RETURN(@intErrorCode)

END
GO

